program fokonyv;
{$APPTYPE CONSOLE}
uses
  SysUtils, Controls;

type // A tranzakci adatait trol adatstruktra
    TAdat = record
       datum    : Tdate;
       forgalom : currency;
    end;

    TEv = array of TAdat;

//  A tranzakcik ltrehozsa s dinamikus tmbben val trolsa
procedure feltolt(evsz : integer; var aktev : TEv; trn : integer);
const
   // A hnapok napjai
   napok:array[1..12] of byte = (31,0,31,30,31,30,31,31,30,31,30,31);
var
   i : integer;
   ev, ho, nap : word;
begin
   randomize;
   Setlength(aktev,trn);         // a trol hossznak belltsa
   for i:=0 to trn-1 do
     begin
        ev:=evsz;
        if isLeapYear(ev) then   // szkv-e
           napok[2]:= 29
        else
           napok[2]:=28;
        // Az adott ven belli dtum vletlenszer ellltsa
        ho:=random(12)+1;
        nap:=random(napok[ho])+1;
        aktev[i].datum:=encodedate(ev,ho,nap);  // A dtum TDateTime formban
        aktev[i].forgalom:=(2*random(2)-1)*random(maxint)/1e5;
     end;
end;


// A tranzakcik dtum szerinti sorbarendezse
procedure rendez(var aktev : TEv; trn : integer);
var
    i,j : integer;
    adat : TAdat;
begin
   for i:=0 to trn-2 do
     for j:=i+1 to trn-1 do
       if aktev[i].datum>aktev[j].datum then
          begin
             adat:=aktev[i];
             aktev[i]:=aktev[j];
             aktev[j]:=adat;
          end;
end;

// A tranzakcik megjelentse
procedure kiir(const aktev : TEv; trn : integer);
var
   i : integer;
begin
   ThousandSeparator:=#32;
   for i:=0 to trn-1 do
     begin
        write(formatdateTime('yyyy.mm.dd.',aktev[i].datum));
        writeln(format('%20.2m',[aktev[i].forgalom]));
     end;
end;

// Fprogram
var
    ev : TEv;
    evszam, n :word;
begin
  write('A vizsgalt ev:');
  readln(evszam);
  write('A tranzakciok szama:');
  readln(n);
  feltolt(evszam, ev, n);
  rendez(ev, n);
  kiir(ev, n);
  readln;
end.